import ReactJson, {InteractionProps} from 'react-json-view';
import React, {useCallback} from 'react';

interface IReactJsonEditorProps {
    orderId: string;
    payload: object;
    onChange: (editedPayload: object | null) => void;
}

const ReactJsonEditor: React.FC<IReactJsonEditorProps> = props => {
    const {orderId, payload, onChange} = props;

    const handleReactJsonChange = useCallback(
        (editingInfo: InteractionProps) => {
            if (editingInfo.existing_value === editingInfo.new_value) {
                return true;
            }

            onChange(editingInfo.updated_src);

            return true;
        },
        [onChange],
    );

    return (
        <ReactJson
            key={orderId}
            src={payload}
            theme="eighties"
            displayObjectSize={false}
            displayDataTypes={false}
            onEdit={handleReactJsonChange}
            onAdd={handleReactJsonChange}
            onDelete={handleReactJsonChange}
            collapsed={2}
            collapseStringsAfterLength={50}
            style={{
                padding: '8px',
                fontFamily: 'inherit',
                borderRadius: '8px',
                margin: '0 -8px',
                wordBreak: 'break-word',
            }}
        />
    );
};

export default ReactJsonEditor;
