import React, {ChangeEvent, useCallback} from 'react';
import {compose} from '@bem-react/core';
import {block} from 'bem-cn';

import {
    Textarea as TextareaDesktop,
    withViewDefault,
    withSizeM,
} from '@yandex-lego/components/Textarea/desktop';

import './index.scss';

const Textarea = compose(withViewDefault, withSizeM)(TextareaDesktop);

export interface ITextareaJsonEditorProps {
    payload: object;
    onChange: (editedPayload: object | null) => void;
}

const b = block('TextareaJsonEditor');

const TextareaJsonEditor: React.FC<ITextareaJsonEditorProps> = props => {
    const {payload, onChange} = props;

    const handleChange = useCallback(
        (event: ChangeEvent<HTMLTextAreaElement>) => {
            const result = JSON.parse(event.target.value);

            onChange(result);
        },
        [onChange],
    );

    return (
        <Textarea
            size="m"
            view="default"
            value={JSON.stringify(payload, null, 4)}
            onChange={handleChange}
            className={b()}
        />
    );
};

export default TextareaJsonEditor;
