import React, {useEffect, useMemo} from 'react';
import {useDispatch, useSelector} from 'react-redux';
import {Loader} from '@yandex-data-ui/common';
import {useParams} from 'react-router-dom';
import {block} from 'bem-cn';
import {
    orderPayloadsRequest,
    resetOrderPayloads,
} from 'redux/reducers/order/actions';

import {IStore} from 'redux/reducers/types';

import Heading from 'components/basic/Heading/Heading';
import OrderPayload from 'components/Order/OrderPayloads/OrderPayload/OrderPayload';

import './index.scss';

interface IRouteParams {
    id: string;
}

const b = block('OrderPayloads');

const OrderPayloads: React.FC = () => {
    const dispatch = useDispatch();

    const {
        order: {
            payloads: {
                items: {value: payloads, isLoading, isFetched, error},
            },
        },
    } = useSelector((store: IStore) => store);

    const {id: orderId} = useParams<IRouteParams>();

    useEffect(() => {
        dispatch(orderPayloadsRequest({orderId}));

        return () => {
            dispatch(resetOrderPayloads());
        };
    }, []);

    const content = useMemo(() => {
        if ((!isLoading && !isFetched) || !payloads) {
            return null;
        }

        if (isLoading) {
            return (
                <div className={b('loaderWrapper')}>
                    <Loader size="m" />
                </div>
            );
        }

        if (error) {
            return (
                <div className="text-danger">
                    Ошибка загрузки информации об услугах
                </div>
            );
        }

        return payloads.map(payloadInfo => (
            <OrderPayload
                key={payloadInfo.order_item_id}
                orderId={orderId}
                payloadInfo={payloadInfo}
            />
        ));
    }, [isLoading, isFetched, payloads, error, orderId]);

    return (
        <div className={b()}>
            <Heading level="1">Информация об услугах</Heading>

            {content}
        </div>
    );
};

export default OrderPayloads;
