import React from 'react';
import block from 'bem-cn';

import Heading from 'components/basic/Heading/Heading';

const b = block('OrderPostPay');

interface IOwnProps {
    className?: string;
    eligible: boolean;
    used: boolean;
}

const OrderPostPay: React.FC<IOwnProps> = props => {
    const {className, eligible, used} = props;

    return (
        <div className={b.mix(className)}>
            <Heading level="4">Постоплата</Heading>
            <div>Была доступна при заказе: {eligible ? 'да' : 'нет'}</div>
            <div>Выбрана: {used ? 'да' : 'нет'}</div>
        </div>
    );
};

export default OrderPostPay;
