import React from 'react';
import {block} from 'bem-cn';

import {IOrderInfo} from 'redux/reducers/types';

import Heading from 'components/basic/Heading/Heading';

import './index.scss';

const b = block('OrderRaw');

interface IOrderRawProps {
    className?: string;
    order: IOrderInfo;
}

const OrderRaw: React.FC<IOrderRawProps> = props => {
    const {className, order} = props;

    return (
        <div className={b.mix(className)}>
            <Heading level="4">Исходный вид заказа</Heading>

            <div>
                <pre className={b('code')}>
                    {JSON.stringify(order, null, 2)}
                </pre>
            </div>
        </div>
    );
};

export default OrderRaw;
