import React from 'react';
import {block} from 'bem-cn';

import {
    IOrderPaymentInfoItemReceipt,
    OrderPaymentInfoReceiptTypes,
} from 'redux/reducers/types';

import './index.scss';

const b = block('OrderReceipts');

interface IOwnProps {
    receipts: IOrderPaymentInfoItemReceipt[];
}

const RECEIPT_HUMAN_TEXT_MAP = {
    [OrderPaymentInfoReceiptTypes.FRT_ACQUIRE]: 'Приход',
    [OrderPaymentInfoReceiptTypes.FRT_CLEAR]: 'Возврат',
};

const OrderReceipts: React.FC<IOwnProps> = props => {
    const {receipts} = props;

    return (
        <div className={b()}>
            Чеки:
            {receipts.length
                ? receipts.map(({type, url}, index) => (
                      <a
                          key={index}
                          className={b('item')}
                          href={url}
                          target="_blank"
                          rel="noopener noreferrer"
                      >
                          {RECEIPT_HUMAN_TEXT_MAP[type] || 'Другой'}
                      </a>
                  ))
                : ' нет'}
        </div>
    );
};

export default OrderReceipts;
