import React from 'react';
import {block} from 'bem-cn';

import {IOrderRoomInfo} from 'redux/reducers/types/hotel';

import './index.scss';
import Heading from 'components/basic/Heading/Heading';

const b = block('OrderRoomInfos');

interface IOrderRoomInfoProps {
    roomInfo: IOrderRoomInfo;
    isTechTexts: boolean;
}

type OrderRoominfoType = IOrderRoomInfoProps;

const OrderRoomInfo: React.FC<OrderRoominfoType> = props => {
    const {
        roomInfo: {amenities, pansion_info, bed_groups},
        isTechTexts,
    } = props;

    return (
        <div className={b()}>
            <Heading level="5">О номере</Heading>
            <div className={b('item')}>
                Пансион:{' '}
                <span title={pansion_info.pansion_type}>
                    {isTechTexts
                        ? pansion_info.pansion_type
                        : pansion_info.name}
                </span>
            </div>
            <div className={b('item')}>
                Удобства:{' '}
                {(amenities.length &&
                    amenities
                        .map(amenity =>
                            isTechTexts ? amenity.id : amenity.name,
                        )
                        .join(', ')) ||
                    'нет информации'}
            </div>
            <div className={b('item')}>
                Кровати:{' '}
                {(bed_groups.length &&
                    bed_groups
                        .map(bed_group => bed_group.description)
                        .join(', ')) ||
                    'нет информации'}
            </div>
        </div>
    );
};

export default OrderRoomInfo;
