import React, {useEffect, useMemo} from 'react';
import {useDispatch, useSelector} from 'react-redux';
import {Switch, Route} from 'react-router-dom';
import {block} from 'bem-cn';
import {resetOrder} from 'redux/reducers/order/actions';

import {IStore} from 'redux/reducers/types';

import OrderWorkflow from 'components/Order/OrderWorkflow/OrderWorkflow';
import OrderPayloads from 'components/Order/OrderPayloads/OrderPayloads';
import OrderLogs from 'components/Order/OrderLogs/OrderLogs';
import Order from 'components/Order/Order';
import OrderRaw from 'components/Order/OrderRaw/OrderRaw';
import ErrorBoundary from 'components/basic/ErrorBoundary';
import Heading from 'components/basic/Heading/Heading';

import './index.scss';

const b = block('OrderRoutes');

const OrderRoutes: React.FC = () => {
    const dispatch = useDispatch();

    const {
        order: {
            item: {value: order},
        },
    } = useSelector((store: IStore) => store);

    const errorBlock = useMemo(() => {
        return (
            <div className={b('errorBlock')}>
                <Heading level="1">На странице что-то сломалось</Heading>

                {order && <OrderRaw order={order} />}
            </div>
        );
    }, [order]);

    useEffect(
        () => () => {
            dispatch(resetOrder());
        },
        [dispatch],
    );

    return (
        <ErrorBoundary errorBlock={errorBlock}>
            <Switch>
                <Route
                    exact
                    path="/:id/workflow/:workflowId"
                    component={OrderWorkflow}
                />
                <Route exact path="/:id/payloads" component={OrderPayloads} />
                <Route exact path="/:id/logs" component={OrderLogs} />
                <Route exact path="/:id" component={Order} />
            </Switch>
        </ErrorBoundary>
    );
};

export default OrderRoutes;
