import React, {useEffect, useMemo} from 'react';
import {useDispatch} from 'react-redux';
import {Loader} from '@yandex-data-ui/common';
import {block} from 'bem-cn';
import {orderStartrekTicketsRequest} from 'redux/reducers/order/actions';

import {IOrderStartrekTicket} from 'redux/reducers/types';

import Heading from 'components/basic/Heading/Heading';

import './index.scss';

const b = block('OrderStartrekTickets');

interface IOrderStartrekTicketsProps {
    className?: string;
    ticketsIds: string[];
    ticketsData: IOrderStartrekTicket[] | null;
    isLoading: boolean;
    isFetched: boolean;
    error: unknown;
}

const OrderStartrekTickets: React.FC<IOrderStartrekTicketsProps> = props => {
    const dispatch = useDispatch();

    const {className, ticketsIds, ticketsData, isLoading} = props;

    useEffect(() => {
        dispatch(orderStartrekTicketsRequest({ticketsIds}));
    }, [dispatch, ticketsIds]);

    const content = useMemo(() => {
        if (isLoading) {
            return <Loader className={b('loader').toString()} size="m" />;
        }

        if (!ticketsData) {
            return null;
        }

        return (
            <div>
                {ticketsData.map(({link, image, id, status, title, user}) => (
                    <div key={id.value}>
                        <a
                            href={link}
                            target="_blank"
                            rel="noopener noreferrer"
                        >
                            <span
                                className={b('icon')}
                                style={{
                                    backgroundImage: `url(${image.src})`,
                                    width: `${image.width}px`,
                                    height: `${image.height}px`,
                                }}
                            >
                                &nbsp;
                            </span>
                            &nbsp;
                            <span
                                style={
                                    id.strike
                                        ? {
                                              color: id.color,
                                              textDecoration: 'line-through',
                                          }
                                        : {}
                                }
                            >
                                {id.value}
                            </span>
                            &nbsp;
                            <span style={{color: status.color}}>
                                {status.value}
                            </span>
                            &nbsp;
                            <span>{title.value}</span>
                            {user.value ? (
                                <>
                                    &nbsp;
                                    <span className={b('user')}>
                                        {user.value}
                                    </span>
                                </>
                            ) : null}
                        </a>
                    </div>
                ))}
            </div>
        );
    }, [isLoading, ticketsData]);

    return (
        <div className={b.mix(className)}>
            <Heading level="4">Связанные задачи</Heading>

            {isLoading ? (
                <Loader className={b('loader').toString()} size="m" />
            ) : (
                content
            )}
        </div>
    );
};

export default OrderStartrekTickets;
