import React from 'react';
import {block} from 'bem-cn';

import {ETaxiPromoStatus, ITaxiPromo} from 'redux/reducers/types';

import Heading from 'components/basic/Heading/Heading';

interface IOrderPromosProps {
    className?: string;
    promo: ITaxiPromo;
}

const b = block('OrderTaxiPromo');

function getDescription(status: ETaxiPromoStatus): string {
    if (status === ETaxiPromoStatus.OTPS_EMAIL_SENT) {
        return 'Письмо успешно отправлено.';
    }

    if (status === ETaxiPromoStatus.OTPS_SENDING_EMAIL) {
        return 'Письмо в процессе отправки.';
    }

    if (status === ETaxiPromoStatus.OTPS_ELIGIBLE) {
        return 'Заказ участвует в акции. Письмо еще не отправлено.';
    }

    return '';
}

const OrderTaxiPromo: React.FC<IOrderPromosProps> = props => {
    const {
        className,
        promo: {status, email},
    } = props;

    if (status === ETaxiPromoStatus.OTPS_NOT_ELIGIBLE) {
        return null;
    }

    return (
        <div className={b.mix(className)}>
            <Heading level="4">Акция Я.Такси</Heading>

            <div>{getDescription(status)}</div>

            {email && <div>{email}</div>}
        </div>
    );
};

export default React.memo(OrderTaxiPromo);
