import React from 'react';
import {block} from 'bem-cn';

import {IOrderVoucher} from 'redux/reducers/types';

import './index.scss';
import Heading from 'components/basic/Heading/Heading';

const b = block('OrderVouchers');

interface IOrderVouchers {
    vouchers: IOrderVoucher[];
    hasMaskedData: boolean;
    isTechTexts: boolean;
}

type VouchersType = IOrderVouchers;

const OrderVouchers: React.FC<VouchersType> = props => {
    const {vouchers, hasMaskedData, isTechTexts} = props;

    return (
        <div className={b()}>
            <Heading level="5">Ваучеры</Heading>
            {vouchers.length
                ? vouchers.map(({id, name, url}, index) => {
                      if (hasMaskedData) {
                          return (
                              <span key={index} className={b('item')}>
                                  *****
                              </span>
                          );
                      }

                      let voucherName = `Ваучер ${index + 1}`;

                      if (isTechTexts) {
                          voucherName = `${id} ${name}`;
                      }

                      if (url) {
                          return (
                              <a
                                  key={index}
                                  href={url}
                                  className={b('item')}
                                  target="_blank"
                                  rel="noopener noreferrer"
                              >
                                  {voucherName}
                              </a>
                          );
                      }

                      return (
                          <span key={index} className={b('item')}>
                              {voucherName} (не сформирован)
                          </span>
                      );
                  })
                : 'нет'}
        </div>
    );
};

export default OrderVouchers;
