import React, {useEffect, useMemo} from 'react';
import {useDispatch, useSelector} from 'react-redux';
import {useParams} from 'react-router-dom';
import {Loader} from '@yandex-data-ui/common';
import ReactJson from 'react-json-view';
import {block} from 'bem-cn';
import {
    orderWorkflowRequest,
    resetOrderWorkflow,
} from 'redux/reducers/order/actions';

import {IStore} from 'redux/reducers/types';

import Heading from 'components/basic/Heading/Heading';

import './index.scss';

const b = block('OrderWorkflow');

interface IRouteParams {
    id: string;
    workflowId: string;
}

const OrderWorkflow: React.FC = () => {
    const dispatch = useDispatch();

    const {workflowId} = useParams<IRouteParams>();

    const {
        order: {
            workflow: {value: workflowData, isLoading, isFetched, error},
        },
    } = useSelector((store: IStore) => store);

    useEffect(() => {
        dispatch(orderWorkflowRequest({workflowId}));

        return () => {
            dispatch(resetOrderWorkflow());
        };
    }, []);

    const content = useMemo(() => {
        if (!isLoading && !isFetched) {
            return null;
        }

        if (isLoading) {
            return (
                <div className={b('loaderWrapper')}>
                    <Loader size="m" />
                </div>
            );
        }

        if (error) {
            return (
                <div className="text-danger">
                    Ошибка загрузки информации о воркфлоу
                </div>
            );
        }

        return (
            <ReactJson
                src={workflowData}
                theme="eighties"
                displayObjectSize={false}
                displayDataTypes={false}
                collapsed={false}
                style={{
                    padding: '8px',
                    fontFamily: 'inherit',
                    borderRadius: '8px',
                    margin: '0 -8px',
                }}
            />
        );
    }, [isLoading, isFetched, error, workflowData]);

    return (
        <div className={b()}>
            <Heading level="1">Воркфлоу</Heading>

            {content}
        </div>
    );
};

export default OrderWorkflow;
