import React, {ReactElement} from 'react';
import {block} from 'bem-cn';

import {EYandexPlusTopupState, IYandexPlus} from 'redux/reducers/types';
import {Environment} from 'shared/types';

import './index.scss';
import getHumanFormatWithTime from 'lib/time/getHumanFormatWithTime';

import PlusIcon from 'components/basic/icons/PlusIcon';
import Heading from 'components/basic/Heading/Heading';

const b = block('YandexPlusInfo');

const HUMAN_STATUSES = {
    [EYandexPlusTopupState.PS_NEW]: 'Выплата запущена',
    [EYandexPlusTopupState.PS_NOT_CLEARED]: 'В процессе',
    [EYandexPlusTopupState.PS_STARTING_PAYMENT]: 'В процессе',
    [EYandexPlusTopupState.PS_WAIT_FOR_PAYMENT]: 'В процессе',

    [EYandexPlusTopupState.PS_CLEARED]:
        'Выполнена (finevents еще не сгенерированы)',
    [EYandexPlusTopupState.PS_FINANCIAL_EVENT_SENT]: 'Выполнена',

    [EYandexPlusTopupState.PS_UNKNOWN]: 'Неизвестно',
    [EYandexPlusTopupState.UNRECOGNIZED]: 'Неизвестно (что-то пошло не так)',
};

function getStatus(
    status: EYandexPlusTopupState | null,
    isTechTexts: boolean,
): string {
    if (isTechTexts) {
        return `${status}`;
    } else if (!status) {
        return 'Запланирована';
    }

    return HUMAN_STATUSES[status] || status;
}

function getDescription(
    plus: IYandexPlus,
    isTechTexts: boolean,
    env: Environment,
): ReactElement {
    switch (plus.mode) {
        case 'TOPUP':
            if (plus.topup_info) {
                const topup = plus.topup_info;

                const linkText =
                    topup.state == EYandexPlusTopupState.PS_CLEARED
                        ? ' получил '
                        : ' получит ';

                return (
                    <div>
                        Пользователь
                        {topup.purchase_token ? (
                            <a
                                href={`https://scrooge${
                                    env === Environment.production
                                        ? ''
                                        : '-test'
                                }.paysys.yandex-team.ru/payments/?purchase_token=${
                                    topup.purchase_token
                                }`}
                                target="_blank"
                                rel="noopener noreferrer"
                            >
                                {linkText}
                            </a>
                        ) : (
                            linkText
                        )}
                        <b>{topup.amount}</b> баллов{' '}
                        <b>
                            {topup.topup_date &&
                                getHumanFormatWithTime(topup.topup_date)}
                        </b>
                        .<br />
                        Статус выплаты:{' '}
                        <b>{getStatus(topup.state, isTechTexts)}</b>
                    </div>
                );
            }

            break;
        case 'WITHDRAW':
            return (
                <div>
                    Списано баллов плюса: <b>{plus.withdrawal_info?.amount}</b>.
                </div>
            );
    }

    return <div></div>;
}

const YandexPlusInfo: React.FC<{
    className?: string;
    data: IYandexPlus;
    isTechTexts: boolean;
    env: Environment;
}> = ({className, data, isTechTexts, env}) => {
    return (
        <div className={b.mix(className)}>
            <Heading level="4">
                Яндекс.Плюс
                <PlusIcon />
            </Heading>

            {getDescription(data, isTechTexts, env)}
        </div>
    );
};

export default YandexPlusInfo;
