import React, {useMemo} from 'react';
import {useSelector} from 'react-redux';
import {block} from 'bem-cn';

import {IBriefOrderInfo, IStore} from 'redux/reducers/types';

import OrdersListItem from 'components/Orders/OrdersListItem/OrdersListItem';
import OrdersListControls from 'components/Orders/OrdersList/OrdersListControls/OrdersListsControls';

import './index.scss';

interface IOwnProps {
    orders: IBriefOrderInfo[];
    itemsCount: number;
}

const b = block('OrdersList');

const OrdersList: React.FC<IOwnProps> = props => {
    const {orders, itemsCount} = props;

    const {settings} = useSelector((store: IStore) => store);

    const ordersControlsBlock = useMemo(() => {
        return (
            <OrdersListControls
                className={b('controls')}
                itemsCount={itemsCount}
            />
        );
    }, [itemsCount]);

    return (
        <div>
            {ordersControlsBlock}

            <div className={b('table')}>
                <div className={b('row', {head: true})}>
                    <div className={b('cell')}>Номер</div>
                    <div className={b('cell').mix(b('date'))}>Дата</div>
                    <div className={b('cell').mix(b('type'))}>Тип заказа</div>
                    <div className={b('cell').mix(b('partner'))}>Партнер</div>
                    <div className={b('cell').mix(b('status'))}>Статус</div>
                    <div className={b('cell').mix(b('info'))}>Информация</div>
                    <div className={b('cell').mix(b('clients'))}>Клиенты</div>
                    <div className={b('cell').mix(b('sum'))}>Сумма</div>
                    <div className={b('cell').mix(b('defer'))}>Рассрочка</div>
                    <div className={b('cell').mix(b('logs'))}>Логи</div>
                </div>

                {orders.map(order => (
                    <OrdersListItem
                        key={order.order_id}
                        order={order}
                        className={b('row')}
                        cellClassName={b('cell')}
                        isTechTexts={settings.isTechTexts}
                    />
                ))}
            </div>

            {ordersControlsBlock}
        </div>
    );
};

export default OrdersList;
