import React, {useCallback} from 'react';
import {block} from 'bem-cn';
import {useLocation} from 'react-router-dom';

import {DEFAULT_ORDERS_SEARCH_COUNT} from 'constants/search';

import {extendUrl} from 'lib/url/utils';
import {parseOrdersSearch} from 'lib/url/search';

import OrdersSorting from 'components/Orders/OrdersSorting/OrdersSorting';
import Pagination from 'components/basic/Pagination/Pagination';

import './index.scss';

const b = block('OrdersListControls');

interface IOrdersListControlsProps {
    className?: string;
    itemsCount: number;
}

const OrdersListControls: React.FC<IOrdersListControlsProps> = props => {
    const {className, itemsCount} = props;

    const location = useLocation();

    const getPageUrl = useCallback(
        (page: number, count: number): string => {
            return extendUrl(location, {
                page: String(page),
                count: String(count),
            });
        },
        [location],
    );

    const {
        page: currentPage = '1',
        count: itemsPerPage = `${DEFAULT_ORDERS_SEARCH_COUNT}`,
    } = parseOrdersSearch(location.search);

    return (
        <div className={b.mix(className)}>
            <Pagination
                itemsCount={itemsCount}
                itemsPerPage={Number(itemsPerPage)}
                buttonsLimit={5}
                currentPage={Number(currentPage)}
                pageLinkBuilder={getPageUrl}
            />

            <OrdersSorting className={b('sorting')} />
        </div>
    );
};

export default OrdersListControls;
