import React from 'react';
import {block} from 'bem-cn';

import {DisplayOrderType} from 'redux/reducers/types';

import './index.scss';

interface IOwnProps {
    activeType: DisplayOrderType;
    options: DisplayOrderType[];
    onTabClick(displayType?: DisplayOrderType): void;
}

const b = block('OrdersSearchFormOrderType');

const ORDER_TYPES_DICT = {
    [DisplayOrderType.DT_UNKNOWN]: 'Все',
    [DisplayOrderType.DT_AVIA]: 'Авиа',
    [DisplayOrderType.DT_HOTEL]: 'Отели',
    [DisplayOrderType.DT_TRAIN]: 'Поезда',
    [DisplayOrderType.DT_BUS]: 'Автобусы',
    [DisplayOrderType.DT_SUBURBAN]: 'Электрички',
};

const OrdersSearchFormOrderType: React.FC<IOwnProps> = props => {
    const {activeType, options, onTabClick} = props;

    return (
        <div className={b()}>
            {options.map((option, index) => {
                return (
                    <div
                        key={index}
                        className={b('item', {active: option === activeType})}
                        onClick={onTabClick.bind(null, option)}
                    >
                        {ORDER_TYPES_DICT[option]}
                    </div>
                );
            })}
        </div>
    );
};

export default OrdersSearchFormOrderType;
