import {IOrdersSearchFilterQueryParams} from 'lib/url/types';
import {
    DisplayOrderType,
    isDisplayOrderTypeValid,
    isOrderCarrierValid,
    isOrderPartnerValid,
    isOrderReferralPartnerIdValid,
    isOrderStatusValid,
    isPaymentScheduleTypeValid,
    OrderCarrier,
    OrderPartner,
    OrderReferralPartnerId,
    OrderStatus,
    PaymentScheduleType,
} from 'redux/reducers/types';

import {IOrdersSearchFormState} from 'components/Orders/OrdersSearchForm/OrdersSearchForm';

export default function getRecoveredStateFromQuery(
    filterQueryParams: IOrdersSearchFilterQueryParams,
): IOrdersSearchFormState {
    return {
        partnerId: filterQueryParams.partnerId || '',
        prettyId: filterQueryParams.prettyId || '',
        email: filterQueryParams.email || '',
        phone: filterQueryParams.phone || '',
        name: filterQueryParams.name || '',
        card: filterQueryParams.card || '',
        token: filterQueryParams.token || '',
        status: isOrderStatusValid(filterQueryParams.status)
            ? filterQueryParams.status
            : OrderStatus.OS_UNKNOWN,
        partner: isOrderPartnerValid(filterQueryParams.partner)
            ? filterQueryParams.partner
            : OrderPartner.PT_UNKNOWN,
        displayType: isDisplayOrderTypeValid(filterQueryParams.displayType)
            ? filterQueryParams.displayType
            : DisplayOrderType.DT_UNKNOWN,
        fromDate: Number(filterQueryParams.fromDate) || 0,
        toDate: Number(filterQueryParams.toDate) || 0,
        isBroken: filterQueryParams.isBroken === 'true',
        paymentScheduleType: isPaymentScheduleTypeValid(
            filterQueryParams.paymentScheduleType,
        )
            ? filterQueryParams.paymentScheduleType
            : PaymentScheduleType.PST_UNKNOWN,
        ticketNumber: filterQueryParams.ticketNumber || '',
        yandexUid: filterQueryParams.yandexUid || '',
        carrier: isOrderCarrierValid(filterQueryParams.carrier)
            ? filterQueryParams.carrier
            : OrderCarrier.OC_UNKNOWN,
        referralPartnerId: isOrderReferralPartnerIdValid(
            filterQueryParams.referralPartnerId,
        )
            ? filterQueryParams.referralPartnerId
            : OrderReferralPartnerId.ORP_UNKNOWN,
    };
}
