import {ORDERS_SEARCH_FORM_FILTER_PARAMS} from 'components/Orders/OrdersSearchForm/helpers/constants';

import {
    IOrdersSearchFilterQueryParams,
    IOrdersSearchQueryParams,
} from 'lib/url/types';

import {IOrdersSearchFormState} from 'components/Orders/OrdersSearchForm/OrdersSearchForm';

export default function getSearchQueryParamsFromState(
    state: IOrdersSearchFormState,
): IOrdersSearchFilterQueryParams {
    return ORDERS_SEARCH_FORM_FILTER_PARAMS.reduce(
        (
            searchQuery: IOrdersSearchQueryParams,
            searchParam: keyof IOrdersSearchFilterQueryParams,
        ): IOrdersSearchQueryParams => ({
            ...searchQuery,
            ...(state[searchParam]
                ? {[searchParam]: String(state[searchParam]).trim()}
                : {}),
        }),
        {},
    );
}
