import React, {useEffect, useState, useCallback, useMemo} from 'react';
import {useLocation, useHistory} from 'react-router-dom';
import {block} from 'bem-cn';

import {isSortTypeValid, SortTypes} from 'redux/reducers/types';

import {extendUrl} from 'lib/url/utils';
import {parseOrdersSearch} from 'lib/url/search';

import RadioButton from 'components/lego/RadioButton/RadioButton';

interface IOrdersSortingProps {
    className?: string;
}

const b = block('OrdersSorting');

const OrdersSorting: React.FC<IOrdersSortingProps> = props => {
    const {className} = props;

    const history = useHistory();
    const location = useLocation();

    const {search} = location;

    const [sortType, setSortType] = useState<SortTypes>(SortTypes.SD_DESC);

    const ordersSortingOptions = useMemo(
        () => [
            {value: SortTypes.SD_DESC, children: 'От новых к старым'},
            {value: SortTypes.SD_ASC, children: 'наоборот'},
        ],
        [],
    );

    const handleChange = useCallback(
        (e: React.ChangeEvent<HTMLInputElement>) => {
            history.push(extendUrl(location, {sortType: e.target.value}));
        },
        [history, location],
    );

    useEffect(() => {
        const {sortType} = parseOrdersSearch(search);

        if (!sortType) {
            return;
        }

        setSortType(isSortTypeValid(sortType) ? sortType : SortTypes.SD_DESC);
    }, [search]);

    return (
        <div className={b.mix(className)}>
            <RadioButton
                options={ordersSortingOptions}
                value={sortType}
                onChange={handleChange}
            />
        </div>
    );
};

export default OrdersSorting;
