import React from 'react';
import {useLocation} from 'react-router-dom';
import {useSelector} from 'react-redux';
import {block} from 'bem-cn';

import {IOrderInfo, IStore} from 'redux/reducers/types';

import Crumb from 'components/basic/Breadcrumbs/Crumb/Crumb';

import './index.scss';

const b = block('Breadcrumbs');

export const PAGES_INFO = {
    ORDERS_SEARCH: {
        path: '',
        title: 'Главная',
    },
    LOGS: {
        path: 'logs',
        title: 'Логи',
    },
    WORKFLOW: {
        path: 'workflow',
        title: 'Воркфлоу',
    },
    PAYLOADS: {
        path: 'payloads',
        title: 'Информация об услугах',
    },
};

export const DISPLAYED_BREADCRUMBS_INFO = Object.values(PAGES_INFO).reduce<{
    [key: string]: {title: string};
}>(
    (info, page) => ({
        ...info,
        [page.path]: {
            title: page.title,
        },
    }),
    {},
);

function getPartTitle(
    part: string,
    partIndex: number,
    order: IOrderInfo | null,
): string {
    if (partIndex === 1) {
        return `Заказ ${order?.yandex_order_id || ''}`;
    }

    return DISPLAYED_BREADCRUMBS_INFO[part]?.title || part;
}

function getPartPath(partIndex: number, isActive: boolean, parts: string[]) {
    if (isActive) {
        if (partIndex === 0) {
            return '/';
        }

        return '';
    }

    return parts.slice(0, partIndex + 1).join('/');
}

const Breadcrumbs: React.FC = () => {
    const {pathname} = useLocation();

    const {
        order: {
            item: {value: order},
        },
    } = useSelector((state: IStore) => state);

    const parts = pathname.split('/');

    if (parts[parts.length - 1] === '') {
        parts.pop();
    }

    const workflowIndex = parts.indexOf(PAGES_INFO.WORKFLOW.path);

    if (workflowIndex !== -1) {
        parts.pop();
    }

    const lastIndex = parts.length - 1;

    return (
        <ol className={b()}>
            {parts.map((part, partIndex) => {
                const isActive = [0, lastIndex].includes(partIndex);

                return (
                    <Crumb
                        key={partIndex}
                        className={b('crumb')}
                        path={getPartPath(partIndex, isActive, parts)}
                        isActive={isActive}
                        title={getPartTitle(part, partIndex, order)}
                    />
                );
            })}
        </ol>
    );
};

export default Breadcrumbs;
