import React, {useMemo} from 'react';
import {block} from 'bem-cn';

import Link from 'components/basic/Link/Link';

const b = block('Crumb');

interface IOwnProps {
    className?: string;
    path: string;
    isActive: boolean;
    title: string;
}

const Crumb: React.FC<IOwnProps> = props => {
    const {className, path, isActive, title} = props;

    const crumb = useMemo(() => {
        if (isActive && path !== '/') {
            return <span>{title}</span>;
        }

        return <Link to={path}>{title}</Link>;
    }, [isActive, title, path]);

    return <li className={b.mix(className)}>{crumb}</li>;
};

export default Crumb;
