import React from 'react';

interface IErrorBoundaryProps {
    errorBlock: React.ReactNode;
}

interface IErrorBoundaryState {
    hasError: boolean;
}

export default class ErrorBoundary extends React.Component<
    IErrorBoundaryProps,
    IErrorBoundaryState
> {
    state = {
        hasError: false,
    };

    componentDidCatch(): void {
        this.setState({hasError: true});
    }

    render() {
        if (this.state.hasError) {
            return this.props.errorBlock;
        }

        return this.props.children;
    }
}
