import React from 'react';
import {block} from 'bem-cn';

import './index.scss';

const b = block('Heading');

interface IHeadingProps {
    className?: string;
    level: '1' | '2' | '3' | '4' | '5' | '6';
}

const Heading: React.FC<IHeadingProps> = props => {
    const {className, level, children} = props;

    return <div className={b({level}).mix(className)}>{children}</div>;
};

export default Heading;
