import React from 'react';
import {Link as RouterLink} from 'react-router-dom';
import {block} from 'bem-cn';

import './index.scss';

const b = block('Link');

interface ILinkProps {
    to: string;
}

const Link: React.FC<ILinkProps> = props => {
    return (
        <RouterLink className={b()} {...props}>
            {props.children}
        </RouterLink>
    );
};

export default Link;
