import React, {useCallback, useState, useEffect} from 'react';
import {compose} from '@bem-react/core';
import {block} from 'bem-cn';

import {
    Textinput as TextinputDesktop,
    withViewDefault as textinputWithViewDefault,
    withSizeS as textinputWithSizeS,
} from '@yandex-lego/components/Textinput/desktop';

import './index.scss';

const Textinput = compose(
    textinputWithSizeS,
    textinputWithViewDefault,
)(TextinputDesktop);

const b = block('MoneyInput');

interface IMoneyInputProps {
    value?: number | null;
    disabled?: boolean;
    onChange: (isValid: boolean, value: number) => void;
}

const MoneyInput: React.FC<IMoneyInputProps> = props => {
    const {value, disabled, onChange} = props;

    const [currentText, setCurrentText] = useState<string>(
        (value && String(value)) || '0',
    );
    const [prevValue, setPrevValue] = useState(value);

    useEffect(() => {
        if (value !== prevValue) {
            setCurrentText((value && String(value)) || '0');
            setPrevValue(value);
        }
    }, [value, prevValue]);

    const handleChange = useCallback(
        event => {
            const text = event.target.value;

            setCurrentText(text);

            const isValidValue =
                !Number.isNaN(Number(text)) && text && Number(text) >= 0;
            const currentValue = isValidValue
                ? Number(Number(text).toFixed(2))
                : NaN;

            onChange(isValidValue, currentValue);
        },
        [onChange],
    );

    return (
        <div className={b()}>
            <Textinput
                size="s"
                view="default"
                value={currentText}
                disabled={disabled}
                onChange={handleChange}
            />

            <span className={b('ruble')}>₽</span>
        </div>
    );
};

export default MoneyInput;
