import React from 'react';

interface IClipboardButtonIconProps {
    size: 's' | 'm';
}

const ClipboardButtonIcon = (props: IClipboardButtonIconProps) => {
    if (props.size === 's') {
        return (
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16">
                <g fill="#000000" fillRule="nonzero">
                    <path d="M2.001 7.332c0-.657.003-.856.022-1.092.022-.274.066-.462.159-.67.161-.308.412-.559.73-.725.171-.086.369-.13.65-.154.242-.022.442-.026 1.106-.026h4c.657 0 .856.003 1.103.023.291.029.484.073.656.162.31.16.56.41.728.73.086.172.13.368.154.659.02.246.026.518.026 1.093v4c0 .66-.003.86-.024 1.108-.028.29-.073.484-.16.654-.16.312-.416.565-.732.725-.173.087-.37.134-.66.159-.236.018-.435.02-1.091.02h-4c-.66 0-.86-.002-1.097-.022a1.892 1.892 0 01-.667-.157 1.723 1.723 0 01-.744-.767 1.924 1.924 0 01-.136-.623c-.02-.237-.023-.436-.023-1.097v-4zm1.382-1.183a.713.713 0 00-.03.198c-.016.185-.018.372-.018.985v4c0 .617.002.804.017.989.011.13.022.178.013.16.034.066.088.12.116.136.019.009.067.02.198.03.185.016.373.018.989.018h4c.614 0 .801-.002.983-.016.13-.011.168-.02.17-.02a.331.331 0 00.144-.145c-.005.01.006-.038.019-.163.015-.185.017-.373.017-.989v-4c0-.538-.004-.788-.02-.983-.012-.134-.02-.176-.013-.161a.36.36 0 00-.152-.153c.008.004-.035-.006-.163-.019C9.468 6.001 9.281 6 8.668 6h-4c-.613 0-.8.003-.986.02-.133.012-.18.022-.163.013a.377.377 0 00-.136.117z" />
                    <path d="M6.668 3.332H5.332a.664.664 0 01-.664-.664c0-.371.297-.668.664-.668h4.402c1.493 0 2.239 0 2.809.29.504.257.91.663 1.168 1.167.289.57.289 1.316.289 2.809v4.402a.664.664 0 01-.668.664.664.664 0 01-.664-.664V6c0-.934 0-1.398-.184-1.758a1.674 1.674 0 00-.726-.726c-.36-.184-.824-.184-1.758-.184H6.668z" />
                </g>
            </svg>
        );
    }

    return (
        <svg
            width="24"
            height="24"
            fill="#000000"
            xmlns="http://www.w3.org/2000/svg"
        >
            <path
                d="M4 11c0-.717 0-1.194.03-1.56.03-.356.081-.518.133-.621a1.5 1.5 0 01.656-.656c.103-.052.265-.103.62-.132C5.806 8 6.283 8 7 8h6c.717 0 1.194 0 1.56.03.356.03.518.081.621.133a1.5 1.5 0 01.655.656c.053.103.104.265.133.62.03.367.031.844.031 1.561v6c0 .717 0 1.194-.03 1.56-.03.356-.081.518-.134.621a1.5 1.5 0 01-.655.655c-.103.053-.265.104-.62.133C14.194 20 13.717 20 13 20H7c-.717 0-1.194 0-1.56-.03-.356-.03-.518-.081-.621-.133a1.5 1.5 0 01-.656-.656c-.052-.103-.103-.265-.132-.62C4 18.194 4 17.717 4 17v-6z"
                stroke="#000000"
                strokeWidth="2"
                fill="none"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M10 5H8a1 1 0 010-2h6.6c2.24 0 3.36 0 4.216.436a4 4 0 011.748 1.748C21 6.04 21 7.16 21 9.4V16a1 1 0 11-2 0V9c0-1.4 0-2.1-.273-2.635a2.5 2.5 0 00-1.092-1.093C17.1 5 16.4 5 15 5h-5z"
            />
        </svg>
    );
};

export default ClipboardButtonIcon;
