import React from 'react';

interface ICloseIconProps {
    width?: number;
    height?: number;
    fill?: string;
}

const CloseIcon = (props: ICloseIconProps) => (
    <svg viewBox="0 0 16 16" fill="none" {...props}>
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M1.793 1.793a1 1 0 0 0 0 1.414L6.586 8l-4.793 4.793a1 1 0 1 0 1.414 1.414L8 9.414l4.793 4.793a1 1 0 0 0 1.414-1.414L9.414 8l4.793-4.793a1 1 0 0 0-1.414-1.414L8 6.586 3.207 1.793a1 1 0 0 0-1.414 0z"
            fill={props.fill}
        />
    </svg>
);

CloseIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
    focusable: 'false',
};

export default CloseIcon;
