import React from 'react';

interface ICouponIconProps {
    active: boolean;
}

const CouponIcon = (props: ICouponIconProps) => {
    const {active} = props;
    const color = active ? '#d00' : '#009e81';

    return (
        <svg
            width="20"
            height="16"
            xmlns="http://www.w3.org/2000/svg"
            fillOpacity={active ? 1 : 0.1}
        >
            <path
                fill={color}
                stroke="null"
                d="m11.215443,9.414374c0.169275,0 0.414711,-0.281681 0.414711,-0.722855c0,-0.441208 -0.245436,-0.722855 -0.414711,-0.722855c-0.169275,0 -0.414711,0.281681 -0.414711,0.722855c0,0.441208 0.245436,0.722855 0.414711,0.722855z"
            />
            <path
                fill={color}
                stroke="null"
                d="m14.533014,11.582973c-0.169275,0 -0.414711,0.281681 -0.414711,0.722855s0.245436,0.722855 0.414711,0.722855s0.414711,-0.281681 0.414711,-0.722855s-0.245436,-0.722855 -0.414711,-0.722855z"
            />
            <path
                fill={color}
                stroke="null"
                d="m19.509389,8.691518c0.229224,0 0.414711,-0.161662 0.414711,-0.361445l0,-1.807155c0,-0.797333 -0.743968,-1.445744 -1.658844,-1.445744l-3.121198,0c-0.119083,-0.229905 -0.196178,-0.469739 -0.196178,-0.722855c0,-0.654409 0.416733,-1.25938 1.087805,-1.578808c0.097584,-0.046591 0.170091,-0.125643 0.200066,-0.219198c0.030364,-0.093182 0.016212,-0.193412 -0.038878,-0.277784l-1.010437,-1.538215c-0.22071,-0.33532 -0.577104,-0.574984 -1.003556,-0.674502c-0.42443,-0.098841 -0.8683,-0.04693 -1.248176,0.145771l-12.093875,6.136255c-0.784868,0.398141 -1.054992,1.282659 -0.602608,1.970952l1.044883,1.591854c0.055479,0.084711 0.147814,0.146143 0.255933,0.170472c0.107731,0.024363 0.222732,0.009894 0.318333,-0.040255c0.334506,-0.175792 0.692533,-0.265077 1.063895,-0.265077c0.905273,0 1.69605,0.519786 1.965279,1.27168c-0.268491,0.727192 -1.042745,1.258398 -1.965085,1.258398c-0.229224,0 -0.414711,0.161662 -0.414711,0.361445l0,1.807155c0,0.797333 0.743968,1.445744 1.658844,1.445744l14.099665,0c0.914875,0 1.658844,-0.648377 1.658844,-1.445744l0,-1.807155c0,-0.199782 -0.185487,-0.361445 -0.414711,-0.361445c-1.143283,0 -2.073554,-0.810751 -2.073554,-1.807155c0,-0.996438 0.930271,-1.807189 2.073554,-1.807189zm-16.587892,0.361445c-0.379449,0 -0.75812,0.06848 -1.114086,0.200494l-0.848822,-1.293603c-0.227203,-0.345214 -0.092335,-0.78815 0.299671,-0.987221l1.271231,-0.644989c-0.010108,0.064516 -0.022666,0.128422 -0.022666,0.195309l0,1.807155c0,0.199782 0.185487,0.361445 0.414711,0.361445c0.763018,0 1.423788,0.365172 1.783836,0.901629c-0.496627,-0.340538 -1.118712,-0.540218 -1.783875,-0.540218zm10.430599,-8.21662c0.187508,-0.095317 0.40783,-0.12178 0.615982,-0.072343c0.211807,0.049403 0.388391,0.16871 0.498143,0.335659l0.815231,1.241015c-0.726123,0.47472 -1.163111,1.217736 -1.163111,2.013646c0,0.24512 0.046304,0.488138 0.128219,0.722855l-9.252714,0l8.35825,-4.240832zm-5.039552,14.451343c0,0.199782 -0.185487,0.361445 -0.414711,0.361445c-0.229224,0 -0.414711,-0.161662 -0.414711,-0.361445l0,-0.722855c0,-0.199782 0.185487,-0.361445 0.414711,-0.361445c0.229224,0 0.414711,0.161662 0.414711,0.361445l0,0.722855zm0,-2.891489c0,0.199782 -0.185487,0.361445 -0.414711,0.361445c-0.229224,0 -0.414711,-0.161662 -0.414711,-0.361445l0,-0.722855c0,-0.199782 0.185487,-0.361445 0.414711,-0.361445c0.229224,0 0.414711,0.161662 0.414711,0.361445l0,0.722855zm0,-2.891455c0,0.199782 -0.185487,0.361445 -0.414711,0.361445c-0.229224,0 -0.414711,-0.161662 -0.414711,-0.361445l0,-0.722855c0,-0.199782 0.185487,-0.361445 0.414711,-0.361445c0.229224,0 0.414711,0.161662 0.414711,0.361445l0,0.722855zm0,-2.891455c0,0.199782 -0.185487,0.361445 -0.414711,0.361445c-0.229224,0 -0.414711,-0.161662 -0.414711,-0.361445l0,-0.813225c0,-0.199782 0.185487,-0.361445 0.414711,-0.361445c0.229224,0 0.414711,0.161662 0.414711,0.361445l0,0.813225zm2.902899,0.632486c0.697781,0 1.244094,0.634993 1.244094,1.445744c0,0.810751 -0.546313,1.445744 -1.244094,1.445744c-0.697781,0 -1.244094,-0.634993 -1.244094,-1.445744c0,-0.810751 0.546313,-1.445744 1.244094,-1.445744zm-0.829811,6.505798c-0.086659,0 -0.173745,-0.023651 -0.248236,-0.072343c-0.183465,-0.119646 -0.22071,-0.346264 -0.083004,-0.505792l4.976375,-5.782943c0.137278,-0.159528 0.397682,-0.191311 0.580331,-0.072343c0.183465,0.119646 0.22071,0.346264 0.083004,0.505792l-4.976375,5.782943c-0.08141,0.094944 -0.205742,0.144686 -0.332095,0.144686zm4.147381,0c-0.697781,0 -1.244094,-0.634993 -1.244094,-1.445744s0.546313,-1.445744 1.244094,-1.445744s1.244094,0.634993 1.244094,1.445744s-0.546313,1.445744 -1.244094,1.445744z"
            />
        </svg>
    );
};

export default CouponIcon;
