import React from 'react';

interface IInstallmentPlanIconProps {
    active: boolean;
}

const InstallmentPlanIcon = (props: IInstallmentPlanIconProps) => {
    const {active} = props;
    const color = active ? '#d00' : '#009e81';

    return (
        <svg
            width="19"
            height="16"
            xmlns="http://www.w3.org/2000/svg"
            fillOpacity={active ? 1 : 0.1}
        >
            <path
                stroke="null"
                fill={color}
                d="m8.179061,13.380335l1.929856,0l0,2.16184c0,0.10518 0.025756,0.19129 0.077566,0.25859c0.05167,0.06774 0.117728,0.10161 0.198201,0.10161l1.438679,0c0.074667,0 0.139276,-0.03387 0.193845,-0.10161c0.054568,-0.06731 0.081774,-0.15344 0.081774,-0.25859l0,-2.16184l4.350698,0c0.080299,0 0.146383,-0.03344 0.198175,-0.10117c0.051836,-0.06768 0.077566,-0.15384 0.077566,-0.25903l0,-1.44109c0,-0.10456 -0.02573,-0.19129 -0.077566,-0.25859c-0.051652,-0.06774 -0.117877,-0.10161 -0.198175,-0.10161l-4.350837,0l0,-1.32851l2.929193,0c1.148645,0 2.086132,-0.45737 2.812888,-1.37341c0.726468,-0.91508 1.089886,-2.09714 1.089886,-3.54625c0,-1.44814 -0.363417,-2.63024 -1.089886,-3.54625c-0.726617,-0.91511 -1.664269,-1.37341 -2.812888,-1.37341l-4.64349,0c-0.080491,0 -0.146409,0.03384 -0.198201,0.10117c-0.05167,0.06771 -0.077566,0.1544 -0.077566,0.259l0,7.0815l-1.929708,0c-0.080465,0 -0.146409,0.03558 -0.198201,0.10686c-0.051652,0.07131 -0.077566,0.15574 -0.077566,0.25328l0,1.67728c0,0.10518 0.025756,0.19135 0.077566,0.25903c0.051818,0.06774 0.117589,0.10117 0.198201,0.10117l1.929856,0l0,1.32851l-1.929856,0c-0.080465,0 -0.146409,0.03387 -0.198201,0.10161c-0.051652,0.06731 -0.077566,0.15384 -0.077566,0.25859l0,1.44109c0,0.10518 0.025756,0.19135 0.077566,0.25903c0.051792,0.06777 0.117702,0.10121 0.198201,0.10121l-0.000009,-0.00001zm3.919772,-10.93112l2.756887,0c0.60874,0 1.099734,0.23258 1.473183,0.69791c0.373257,0.46536 0.559969,1.07349 0.559969,1.82373c0,0.75061 -0.186712,1.35893 -0.559969,1.82373c-0.373449,0.46573 -0.864461,0.69831 -1.473183,0.69831l-2.756887,0l0,-5.04367l0,-0.00001z"
            />
            <rect
                stroke="null"
                fill={color}
                rx="0.5"
                transform="matrix(-0.004680590829289609,-0.7456775696709356,0.7286969865478953,-0.004789661078115824,-2.3877113689102303,13.122046853050298) "
                height="3.116607"
                width="18.608466"
                y="7.152919"
                x="-1.115083"
                strokeOpacity="null"
                strokeWidth="6"
            />
            <rect
                stroke="null"
                fill={color}
                rx="0.5"
                id="svg_16"
                height="2.257657"
                width="7.59208"
                y="13.610858"
                x="0.088295"
                strokeOpacity="null"
                strokeWidth="6"
            />
            <rect
                stroke="null"
                fill={color}
                rx="0.5"
                transform="matrix(0.3848144983073786,-0.63324083068382,0.6188206590175666,0.3937817023662498,-0.7502156656012714,5.440092592436234) "
                id="svg_18"
                height="3"
                width="7.301849"
                y="0.284972"
                x="1.559554"
                strokeOpacity="null"
                strokeWidth="6"
            />
        </svg>
    );
};

export default InstallmentPlanIcon;
