import React from 'react';

interface IMirIconProps {
    active: boolean;
}

const MirIcon = (props: IMirIconProps) => {
    const {active} = props;

    return (
        <svg
            width="50"
            height="16"
            xmlns="http://www.w3.org/2000/svg"
            fillOpacity={active ? 1 : 0.1}
        >
            <path
                stroke="null"
                fill="#0F754E"
                id="Combined-Shape"
                d="m4.691753,0.040126c0.449655,-0.003092 1.786008,-0.141442 2.35206,2.054552c0.3813,1.479245 0.988687,3.902318 1.822162,7.269217l0,0l0.339441,0c0.893828,-3.549622 1.507843,-5.972695 1.842043,-7.269217c0.571949,-2.218868 2.001823,-2.054507 2.573772,-2.054507l4.412727,0.000007l0,15.778575l-4.497571,0l0,-9.298577l-0.301593,0l-2.507173,9.298577l-3.38385,0l-2.507173,-9.305467l-0.301593,0l0,9.305467l-4.497571,0l0,-15.778575l4.65432,-0.000051zm19.800625,0.000051l0,9.305502l0.358794,0l3.049747,-7.651848c0.592009,-1.52274 1.853768,-1.653653 1.853768,-1.653653l0,0l4.352305,0l0,15.77861l-4.591501,0l0,-9.305502l-0.358794,0l-2.989948,7.651848c-0.592009,1.515848 -1.913567,1.653653 -1.913567,1.653653l-4.352305,0l0,-15.77861l4.591501,0zm25.48489,7.498099c-0.640465,2.086219 -2.651785,3.580311 -4.878588,3.580311l0,0l-4.815096,0l0,4.7002l-4.366247,0l0,-8.280511l14.059932,0z"
            />
            <path
                stroke="null"
                fill="url(#linearGradient-1)"
                id="path24"
                d="m45.309262,0.040177l-9.620892,0c0.228967,3.512854 2.860758,6.520086 5.585205,6.520086l9.007083,0c0.519773,-2.919595 -1.269565,-6.520086 -4.971396,-6.520086z"
            />
        </svg>
    );
};

export default MirIcon;
