import React from 'react';

interface IPostPayIconProps {
    active: boolean;
}

const PostPayIcon = (props: IPostPayIconProps) => {
    const {active} = props;

    return (
        <svg
            width="16"
            height="16"
            viewBox="0 0 16 16"
            fillOpacity={active ? 1 : 0.1}
            xmlns="http://www.w3.org/2000/svg"
        >
            <g id="surface1">
                <path d="M 9.703125 1.75 C 8.484375 2.070312 7.695312 3.273438 7.914062 4.484375 C 8.054688 5.261719 8.527344 5.886719 9.242188 6.246094 C 10.519531 6.886719 12.089844 6.226562 12.570312 4.851562 C 12.695312 4.492188 12.726562 3.957031 12.640625 3.570312 C 12.535156 3.089844 12.265625 2.632812 11.882812 2.28125 C 11.632812 2.050781 11.15625 1.804688 10.828125 1.734375 C 10.523438 1.667969 9.976562 1.679688 9.703125 1.75 Z M 10.980469 3.085938 C 11.164062 3.257812 11.40625 3.367188 11.644531 3.398438 L 11.828125 3.421875 L 11.882812 3.625 C 11.953125 3.863281 11.964844 4.289062 11.90625 4.5 C 11.707031 5.230469 11.03125 5.75 10.289062 5.75 C 9.382812 5.746094 8.625 4.988281 8.625 4.074219 L 8.625 3.851562 L 8.832031 3.816406 C 9.585938 3.679688 10.277344 3.28125 10.539062 2.820312 L 10.632812 2.652344 L 10.734375 2.804688 C 10.789062 2.882812 10.898438 3.015625 10.980469 3.085938 Z M 10.980469 3.085938 " />
                <path d="M 7.648438 6.863281 C 6.769531 7.121094 6.15625 7.453125 5.894531 7.808594 C 5.644531 8.148438 5.578125 8.574219 5.601562 9.6875 C 5.617188 10.433594 5.65625 10.855469 5.765625 11.648438 C 5.789062 11.832031 5.8125 11.992188 5.8125 12.007812 C 5.8125 12.019531 5.839844 12.058594 5.875 12.09375 C 5.9375 12.15625 5.976562 12.15625 10.292969 12.15625 C 14.210938 12.15625 14.65625 12.148438 14.699219 12.105469 C 14.761719 12.042969 14.769531 12.019531 14.84375 11.4375 C 14.960938 10.476562 14.980469 10.222656 14.984375 9.453125 C 14.984375 8.308594 14.902344 7.992188 14.519531 7.632812 C 14.289062 7.417969 14.074219 7.289062 13.683594 7.121094 C 13.417969 7.007812 12.566406 6.738281 12.539062 6.757812 C 12.535156 6.769531 10.488281 11.339844 10.328125 11.703125 L 10.289062 11.796875 L 10.203125 11.609375 C 10.160156 11.507812 9.667969 10.375 9.113281 9.09375 C 8.496094 7.671875 8.085938 6.761719 8.058594 6.757812 C 8.035156 6.757812 7.851562 6.800781 7.648438 6.863281 Z M 7.648438 6.863281 " />
                <path d="M 9.921875 6.886719 C 9.878906 6.949219 9.875 7.148438 9.882812 8.441406 L 9.890625 9.921875 L 10.039062 10.144531 C 10.203125 10.394531 10.261719 10.453125 10.324219 10.429688 C 10.351562 10.417969 10.441406 10.304688 10.527344 10.175781 L 10.6875 9.941406 L 10.6875 8.414062 C 10.6875 7.269531 10.679688 6.878906 10.648438 6.851562 C 10.625 6.824219 10.5 6.8125 10.289062 6.8125 C 9.988281 6.8125 9.96875 6.816406 9.921875 6.886719 Z M 9.921875 6.886719 " />
                <path d="M 2.640625 9.839844 C 2.507812 9.898438 2.453125 10 2.4375 10.210938 L 2.421875 10.410156 L 2.214844 10.476562 C 1.648438 10.667969 1.195312 11.148438 1.050781 11.707031 C 0.984375 11.960938 0.988281 11.992188 1.078125 12.078125 L 1.152344 12.15625 L 2.761719 12.15625 C 3.648438 12.15625 4.394531 12.148438 4.421875 12.136719 C 4.445312 12.125 4.492188 12.078125 4.519531 12.027344 C 4.558594 11.945312 4.558594 11.914062 4.511719 11.742188 C 4.4375 11.449219 4.257812 11.132812 4.046875 10.917969 C 3.832031 10.699219 3.632812 10.574219 3.34375 10.476562 L 3.140625 10.410156 L 3.125 10.207031 C 3.113281 10.039062 3.09375 9.988281 3.027344 9.917969 C 2.941406 9.832031 2.75 9.792969 2.640625 9.839844 Z M 2.640625 9.839844 " />
                <path d="M 0.421875 12.996094 C 0.171875 13.109375 0.0351562 13.3125 0.0078125 13.589844 C -0.0078125 13.820312 0.109375 14.066406 0.304688 14.203125 L 0.445312 14.296875 L 15.554688 14.296875 L 15.695312 14.203125 C 15.851562 14.09375 16 13.828125 16 13.660156 C 16 13.378906 15.828125 13.109375 15.578125 12.996094 C 15.460938 12.941406 15.144531 12.9375 8 12.9375 C 0.835938 12.9375 0.539062 12.941406 0.421875 12.996094 Z M 0.421875 12.996094 " />
            </g>
        </svg>
    );
};

export default PostPayIcon;
