import React from 'react';

interface IWaitingIconProps {
    active: boolean;
}

const WaitingIcon = (props: IWaitingIconProps) => {
    const {active} = props;
    const color = active ? '#d00' : '#009e81';

    return (
        <svg
            width="20"
            height="16"
            xmlns="http://www.w3.org/2000/svg"
            fillOpacity={active ? 1 : 0.1}
        >
            <path
                fill={color}
                stroke="null"
                d="m9.865968,13.492497c0.111655,0 0.202127,-0.09328 0.202127,-0.208338l0,-1.278084c0,-1.110497 -0.876501,-2.013934 -1.95389,-2.013934l-1.534275,0c-0.032367,0 -0.062767,-0.012945 -0.085621,-0.036473c-0.023015,-0.023695 -0.035655,-0.05514 -0.035655,-0.08853c0,-0.146948 -0.074248,-0.274867 -0.186765,-0.34648l0,-0.738933c0.810015,-0.40912 1.375538,-1.256028 1.404429,-2.239661c0.19706,-0.025806 0.379324,-0.117253 0.522025,-0.264367c0.170271,-0.175476 0.264058,-0.408842 0.264058,-0.65707c0,-0.404815 -0.25255,-0.749767 -0.603685,-0.876853l0,-2.533751c0,-0.268034 -0.211586,-0.486122 -0.471629,-0.486122l-4.707122,0c-0.260042,0 -0.471629,0.218088 -0.471629,0.486122l0,2.533167c-0.126504,0.045445 -0.242336,0.119892 -0.339492,0.220255c-0.170352,0.175226 -0.264193,0.408592 -0.264193,0.657209c0,0.472038 0.343346,0.862686 0.786083,0.921326c0.028864,0.983689 0.594387,1.830624 1.404429,2.239772l0,0.739683c-0.025414,0.016306 -0.049346,0.035306 -0.070933,0.057557c-0.074679,0.076974 -0.115832,0.17931 -0.115832,0.288173c0,0.068918 -0.054412,0.125003 -0.121276,0.125003l-1.534275,0c-1.077388,0 -1.95389,0.903437 -1.95389,2.013934l0,3.454216c0,0.268034 0.211586,0.486122 0.471629,0.486122l9.125877,0c0.260042,0 0.471629,-0.218088 0.471629,-0.486122l0,-1.203916c0,-0.115058 -0.090472,-0.208338 -0.202127,-0.208338s-0.202127,0.09328 -0.202127,0.208338l0,1.203916c0,0.038279 -0.030211,0.069446 -0.067376,0.069446l-1.580872,0l0,-2.689782c0,-0.115058 -0.090472,-0.208338 -0.202127,-0.208338s-0.202127,0.09328 -0.202127,0.208338l0,2.689782l-3.013868,0l0,-0.34723l1.771167,0c0.083168,0.044279 0.177386,0.069446 0.277264,0.069446c0.334344,0 0.60638,-0.280367 0.60638,-0.625014s-0.272035,-0.625014 -0.60638,-0.625014c-0.099877,0 -0.194095,0.025167 -0.277264,0.069446l-1.771167,0l0,-0.416676l1.771167,0c0.083168,0.044279 0.177386,0.069446 0.277264,0.069446c0.334344,0 0.60638,-0.280367 0.60638,-0.625014s-0.272035,-0.625014 -0.60638,-0.625014c-0.099877,0 -0.194095,0.025167 -0.277264,0.069446l-1.771167,0l0,-0.416676l1.771167,0c0.083168,0.044279 0.177386,0.069446 0.277264,0.069446c0.334344,0 0.60638,-0.280367 0.60638,-0.625014s-0.272035,-0.625014 -0.60638,-0.625014c-0.099877,0 -0.194095,0.025167 -0.277264,0.069446l-1.351094,0l0.175581,-0.330007c0.02784,-0.052835 0.042554,-0.112391 0.042554,-0.172226l0,-0.637236l0.818828,0c0.002264,0.141253 0.05673,0.273784 0.153993,0.373981c0.099204,0.102224 0.231098,0.158531 0.371455,0.158531l1.534275,0c0.854483,0 1.549637,0.716516 1.549637,1.597258l0,1.278084c-0.000027,0.115058 0.090445,0.208338 0.2021,0.208338zm-7.253377,-8.801029l0,-0.416676l4.841873,0l0,0.416676l-4.841873,0zm5.445585,0.929187c0,0.13692 -0.051717,0.265617 -0.145639,0.362425c-0.065705,0.067724 -0.146744,0.113614 -0.234898,0.135392l0,-0.995467c0.217946,0.054307 0.380537,0.256533 0.380537,0.49765zm-5.378209,-3.480077l4.707122,0c0.037164,0 0.067376,0.031167 0.067376,0.069446l0,0.81474l-0.759726,0c-0.111655,0 -0.202127,0.09328 -0.202127,0.208338s0.090472,0.208338 0.202127,0.208338l0.759726,0l0,0.416676l-4.841873,0l0,-0.416676l3.13889,0c0.111655,0 0.202127,-0.09328 0.202127,-0.208338s-0.090472,-0.208338 -0.202127,-0.208338l-3.13889,0l0,-0.81474c0,-0.038279 0.030238,-0.069446 0.067376,-0.069446zm-0.67106,3.480077c0,-0.137114 0.051664,-0.265756 0.145774,-0.362564c0.065516,-0.067696 0.146528,-0.11353 0.234763,-0.135253l0,0.995494c-0.217946,-0.054335 -0.380537,-0.256561 -0.380537,-0.497678zm0.78479,0.842241l0,-1.354752l4.479662,0l0,1.354752c0,1.193193 -0.941802,2.163937 -2.099421,2.163937l-0.280821,0c-1.157619,0 -2.099421,-0.970744 -2.099421,-2.163937zm2.099421,2.580613l0.280821,0c0.240584,0 0.473326,-0.035251 0.693698,-0.100863l0,0.516984l-1.668217,0l0,-0.516984c0.220372,0.065613 0.453114,0.100863 0.693698,0.100863zm-1.269813,5.583457c0,0.114891 -0.09066,0.208338 -0.202127,0.208338s-0.202127,-0.093447 -0.202127,-0.208338s0.09066,-0.208338 0.202127,-0.208338s0.202127,0.093447 0.202127,0.208338zm0.388972,-0.138892l2.042502,0c-0.009891,0.044695 -0.015281,0.091141 -0.015281,0.138892s0.00539,0.094197 0.015281,0.138892l-2.042502,0c0.009891,-0.044695 0.015281,-0.091141 0.015281,-0.138892s-0.00539,-0.094197 -0.015281,-0.138892zm2.835727,0.138892c0,0.114891 -0.09066,0.208338 -0.202127,0.208338s-0.202127,-0.093447 -0.202127,-0.208338s0.09066,-0.208338 0.202127,-0.208338s0.202127,0.093447 0.202127,0.208338zm-3.224699,-1.527812c0,0.114891 -0.09066,0.208338 -0.202127,0.208338s-0.202127,-0.093447 -0.202127,-0.208338s0.09066,-0.208338 0.202127,-0.208338s0.202127,0.093447 0.202127,0.208338zm0.388972,-0.138892l2.042502,0c-0.009891,0.044695 -0.015281,0.091141 -0.015281,0.138892s0.00539,0.094197 0.015281,0.138892l-2.042502,0c0.009891,-0.044695 0.015281,-0.091141 0.015281,-0.138892s-0.00539,-0.094197 -0.015281,-0.138892zm2.835727,0.138892c0,0.114891 -0.09066,0.208338 -0.202127,0.208338s-0.202127,-0.093447 -0.202127,-0.208338s0.09066,-0.208338 0.202127,-0.208338s0.202127,0.093447 0.202127,0.208338zm-3.224699,-1.527812c0,0.114891 -0.09066,0.208338 -0.202127,0.208338s-0.202127,-0.093447 -0.202127,-0.208338s0.09066,-0.208338 0.202127,-0.208338s0.202127,0.093447 0.202127,0.208338zm0.388972,-0.138892l2.042502,0c-0.009891,0.044695 -0.015281,0.091141 -0.015281,0.138892s0.00539,0.094197 0.015281,0.138892l-2.042502,0c0.009891,-0.044695 0.015281,-0.091141 0.015281,-0.138892s-0.00539,-0.094197 -0.015281,-0.138892zm2.835727,0.138892c0,0.114891 -0.09066,0.208338 -0.202127,0.208338s-0.202127,-0.093447 -0.202127,-0.208338s0.09066,-0.208338 0.202127,-0.208338s0.202127,0.093447 0.202127,0.208338zm-2.016603,-1.072329l-0.274892,0.516761l-0.858067,0c-0.083168,-0.044279 -0.177386,-0.069446 -0.277264,-0.069446c-0.334371,0 -0.60638,0.280367 -0.60638,0.625014s0.272008,0.625014 0.60638,0.625014c0.099877,0 0.194095,-0.025167 0.277264,-0.069446l0.494779,0l0,0.416676l-0.494779,0c-0.083168,-0.044279 -0.177386,-0.069446 -0.277264,-0.069446c-0.334371,0 -0.60638,0.280367 -0.60638,0.625014s0.272008,0.625014 0.60638,0.625014c0.099877,0 0.194095,-0.025167 0.277264,-0.069446l0.494779,0l0,0.416676l-0.494779,0c-0.083168,-0.044279 -0.177386,-0.069446 -0.277264,-0.069446c-0.334371,0 -0.60638,0.280367 -0.60638,0.625014s0.272008,0.625014 0.60638,0.625014c0.099877,0 0.194095,-0.025167 0.277264,-0.069446l0.494779,0l0,0.34723l-1.737479,0l0,-2.689782c0,-0.115058 -0.090499,-0.208338 -0.202127,-0.208338s-0.202127,0.09328 -0.202127,0.208338l0,2.689782l-1.580899,0c-0.037137,0 -0.067376,-0.031167 -0.067376,-0.069446l0,-3.454243c0,-0.880742 0.695153,-1.597258 1.549637,-1.597258l1.534275,0c0.286804,0 0.520678,-0.238033 0.525448,-0.532512l0.818828,0l0,0.622708z"
            />
            <path
                fill={color}
                stroke="null"
                d="m6.111535,6.327422c0.111655,0 0.202127,-0.09328 0.202127,-0.208338l0,-0.416676c0,-0.115058 -0.090472,-0.208338 -0.202127,-0.208338s-0.202127,0.09328 -0.202127,0.208338l0,0.416676c0,0.115058 0.090499,0.208338 0.202127,0.208338z"
            />
            <path
                fill={color}
                stroke="null"
                d="m3.955519,5.49407c-0.111628,0 -0.202127,0.09328 -0.202127,0.208338l0,0.416676c0,0.115058 0.090499,0.208338 0.202127,0.208338s0.202127,-0.09328 0.202127,-0.208338l0,-0.416676c0,-0.115058 -0.090499,-0.208338 -0.202127,-0.208338z"
            />
            <path
                fill={color}
                stroke="null"
                d="m5.551968,7.748314c0.078937,-0.081363 0.078937,-0.213283 -0.000027,-0.294645c-0.07891,-0.081363 -0.206897,-0.081335 -0.285834,0c-0.062147,0.064085 -0.144776,0.099363 -0.232688,0.099363s-0.170541,-0.035306 -0.232715,-0.099363c-0.078937,-0.081363 -0.206924,-0.081363 -0.285834,0c-0.078937,0.081363 -0.078937,0.213283 0,0.294618c0.138524,0.142781 0.322675,0.221394 0.518549,0.221394s0.380025,-0.078613 0.518549,-0.221366z"
            />
            <path
                fill={color}
                stroke="null"
                d="m15.269442,0.191722c-2.526463,0 -4.582016,2.021884 -4.582016,4.507199s2.055553,4.507199 4.582016,4.507199c2.52657,0 4.582016,-2.021884 4.582016,-4.507199s-2.055553,-4.507199 -4.582016,-4.507199zm0,8.356417c-2.157664,0 -3.913113,-1.726785 -3.913113,-3.849218s1.755449,-3.849218 3.913113,-3.849218s3.913113,1.726768 3.913113,3.849112c0,2.122538 -1.755449,3.849324 -3.913113,3.849324z"
            />
            <path
                fill={color}
                stroke="null"
                d="m16.830227,4.698921l-1.449295,0l0,-1.973959c0,-0.181714 -0.149721,-0.32899 -0.334451,-0.32899s-0.334451,0.147276 -0.334451,0.32899l0,2.30295c0,0.181714 0.149721,0.32899 0.334451,0.32899l1.783747,0c0.18473,0 0.334451,-0.147276 0.334451,-0.32899s-0.149721,-0.32899 -0.334451,-0.32899z"
            />
        </svg>
    );
};

export default WaitingIcon;
