import React from 'react';
import {compose} from '@bem-react/core';

import {
    Button as ButtonDesktop,
    withSizeM,
    withViewDefault,
    IButtonProps,
} from '@yandex-lego/components/Button/desktop';

import './index.scss';

const Button = compose(withSizeM, withViewDefault)(ButtonDesktop);

const DefaultButton: React.FC<IButtonProps> = props => {
    return <Button view="default" size="m" {...props} />;
};

export default DefaultButton;
