import React from 'react';
import {compose} from '@bem-react/core';

import {
    RadioButton as RadioButtonDesktop,
    withSizeM,
    withViewDefault,
    IRadioButtonProps,
} from '@yandex-lego/components/RadioButton/desktop';

import './index.scss';

const LegoRadioButton = compose(withSizeM, withViewDefault)(RadioButtonDesktop);

const RadioButton: React.FC<IRadioButtonProps> = props => {
    return <LegoRadioButton view="default" size="m" {...props} />;
};

export default RadioButton;
