import React from 'react';
import {compose} from '@bem-react/core';

import {
    Textarea as TextareaDesktop,
    withSizeM,
    withViewDefault,
    ITextareaProps,
} from '@yandex-lego/components/Textarea/desktop';

import './index.scss';

const LegoTextarea = compose(withSizeM, withViewDefault)(TextareaDesktop);

const Textarea: React.FC<ITextareaProps> = props => {
    return <LegoTextarea view="default" size="m" {...props} />;
};

export default Textarea;
