import React from 'react';
import {useTheme} from '@yandex-data-ui/common';

import {ETheme} from 'shared/types';

import {configureRootTheme} from '@yandex-lego/components/Theme';
import {theme as defaultTheme} from '@yandex-lego/components/Theme/presets/default';
import {theme as darkTheme} from '@yandex-lego/components/Theme/presets/inverse';

interface IOwnProps {
    theme: string;
}

const ThemeProvider: React.FC<IOwnProps> = props => {
    const {theme: initialTheme} = props;
    const [theme] = useTheme();

    const currentTheme = theme || initialTheme;

    configureRootTheme({
        theme: currentTheme === ETheme.DARK ? darkTheme : defaultTheme,
    });

    return null;
};

export default ThemeProvider;
