import React from 'react';
import ReactDOM from 'react-dom';
import {BrowserRouter as Router} from 'react-router-dom';
import {ToastProvider} from 'react-toast-notifications';
import {Provider} from 'react-redux';
import store from 'redux/store';

import App from 'components/App/App';
import CustomToastsContainer from 'components/basic/CustomToastsContainer/CustomToastsContainer';

import '@yandex-data-ui/common/styles/styles.scss';

ReactDOM.render(
    <ToastProvider components={{ToastContainer: CustomToastsContainer}}>
        <Provider store={store}>
            <Router>
                <App />
            </Router>
        </Provider>
    </ToastProvider>,
    document.getElementById('root'),
);
