import {OrderCarrier} from 'redux/reducers/types';

export const ORDER_CARRIER_DICT = {
    [OrderCarrier.OC_UNKNOWN]: 'Не важно',
    [OrderCarrier.OC_CPPK]: 'ЦППК',
    [OrderCarrier.OC_SZPPK]: 'СЗППК',
    [OrderCarrier.OC_MTPPK]: 'МТППК',
    [OrderCarrier.OC_BASHPPK]: 'Башкортостанская ППК',
    [OrderCarrier.OC_SODRUZHESTVO]: 'ППК Содружество',
    [OrderCarrier.OC_AEROEXPRESS]: 'Аэроэкспресс',
};

export function getOrderCarrierText(
    carrier: OrderCarrier,
    isTechTexts: boolean,
): string {
    return !isTechTexts && ORDER_CARRIER_DICT[carrier]
        ? ORDER_CARRIER_DICT[carrier]
        : carrier;
}
