import {OrderPartner} from 'redux/reducers/types';

export const ORDER_PARTNER_DICT = {
    [OrderPartner.PT_UNKNOWN]: 'Не важно',
    [OrderPartner.PT_AVIA_AEROFLOT]: 'Аэрофлот',
    [OrderPartner.PT_HOTEL_TRAVELLINE]: 'Трэвеллайн',
    [OrderPartner.PT_HOTEL_DOLPHIN]: 'Дельфин',
    [OrderPartner.PT_HOTEL_BNOVO]: 'Бново',
    [OrderPartner.PT_HOTEL_EXPEDIA]: 'Экспедия',
    [OrderPartner.PT_HOTEL_BRONEVIK]: 'Броневик',
    [OrderPartner.PT_TRAIN_RZHD]: 'РЖД',
    [OrderPartner.PT_MOVISTA]: 'Мовиста',
    [OrderPartner.PT_IM_SUBURBAN]: 'ИМ (электрички)',
    [OrderPartner.PT_AEROEXPRESS]: 'Аэроэкспресс',
    [OrderPartner.PT_BUS_BUSFOR]: '🚌 Басфор',
    [OrderPartner.PT_BUS_ECOLINES]: '🚌 Эколайнс',
    [OrderPartner.PT_BUS_ETRAFFIC]: '🚌 Е-Траффик',
    [OrderPartner.PT_BUS_NOY]: '🚌 Ной',
    [OrderPartner.PT_BUS_OK]: '🚌 ОК',
    [OrderPartner.PT_BUS_RUSET]: '🚌 РУ-Сеть',
    [OrderPartner.PT_BUS_SKS]: '🚌 СКС',
    [OrderPartner.PT_BUS_UNITIKI]: '🚌 Юнитики',
    [OrderPartner.PT_BUS_YUGAVTOTRANS]: '🚌 Югавтотранс',
};

export function getOrderPartnerText(
    status: OrderPartner,
    isTechTexts: boolean,
): string {
    return !isTechTexts && ORDER_PARTNER_DICT[status]
        ? ORDER_PARTNER_DICT[status]
        : status;
}
