import {OrderPaymentStatus} from 'redux/reducers/types';

export const ORDER_PAYMENT_STATUS_DICT = {
    [OrderPaymentStatus.IS_NEW]: 'Новый',
    [OrderPaymentStatus.IS_WAIT_FOR_PAYMENT]: 'Ожидает оплаты',
    [OrderPaymentStatus.IS_HOLD]: 'Деньги авторизованы',
    [OrderPaymentStatus.IS_PAYMENT_NOT_AUTHORIZED]: 'Платеж неуспешен',
    [OrderPaymentStatus.IS_CLEARING]: 'Осуществляется клиринг',
    [OrderPaymentStatus.IS_CLEARED]: 'Деньги поклирены',
    [OrderPaymentStatus.IS_REFUNDING]: 'По платежу обрабатывается возврат',
    [OrderPaymentStatus.IS_REFUNDED]: 'Полностью возвращен',
};

export function getOrderPaymentStatusText(
    status: OrderPaymentStatus,
    isTechTexts: boolean,
): string {
    return !isTechTexts && ORDER_PAYMENT_STATUS_DICT[status]
        ? ORDER_PAYMENT_STATUS_DICT[status]
        : status;
}
