import {OrderReferralPartnerId} from 'redux/reducers/types';

export const ORDER_REFERRAL_PARTNER_ID_DICT = {
    [OrderReferralPartnerId.ORP_UNKNOWN]: 'Не важно',
    [OrderReferralPartnerId.ORP_EMPTY]: 'Отсутствует',
    [OrderReferralPartnerId.ORP_S7]: 'S7',
    [OrderReferralPartnerId.ORP_TINKOFF]: 'Тинькофф',
    [OrderReferralPartnerId.ORP_VTB]: 'ВТБ',
    [OrderReferralPartnerId.ORP_RAIFFEISEN]: 'Райффайзен',
    [OrderReferralPartnerId.ORP_TELE2]: 'Теле2',
    [OrderReferralPartnerId.ORP_OTKRITIE]: 'Открытие',
    [OrderReferralPartnerId.ORP_BEELINE]: 'Билайн',
};

export function getOrderReferralPartnerIdText(
    orderReferralPartnerId: OrderReferralPartnerId,
    isTechTexts: boolean,
): string {
    return !isTechTexts &&
        ORDER_REFERRAL_PARTNER_ID_DICT[orderReferralPartnerId]
        ? ORDER_REFERRAL_PARTNER_ID_DICT[orderReferralPartnerId]
        : orderReferralPartnerId;
}
