import {OrderStatus} from 'redux/reducers/types';

export const ORDER_STATUS_DICT = {
    [OrderStatus.OS_UNKNOWN]: 'Не важно',
    [OrderStatus.OS_IN_PROGRESS]: 'В обработке',
    [OrderStatus.OS_REFUNDED]: 'Возвращён',
    [OrderStatus.OS_FULFILLED]: 'Выполнен',
    [OrderStatus.OS_CANCELLED]: 'Отменён',
    [OrderStatus.OS_AWAITS_PAYMENT]: 'Ожидает оплаты',
};

export function getOrderStatusText(
    status: OrderStatus,
    isTechTexts: boolean,
): string {
    return !isTechTexts && ORDER_STATUS_DICT[status]
        ? ORDER_STATUS_DICT[status]
        : status;
}
