import {EOrderPaymentRefundState} from 'redux/reducers/types';

export const ORDER_REFUND_STATUS_DICT = {
    [EOrderPaymentRefundState.RS_NEW]: 'Новый',
    [EOrderPaymentRefundState.RS_CREATE]: 'Создаем возврат в трасте',
    [EOrderPaymentRefundState.RS_START]: 'Стартуем возврат в трасте',
    [EOrderPaymentRefundState.RS_IN_PROCESS]: 'Ждем статус возврата от траста',
    [EOrderPaymentRefundState.RS_SUCCESS]: 'Деньги возвращены',
    [EOrderPaymentRefundState.RS_FAILED]: 'Не удалось вернуть',
    [EOrderPaymentRefundState.RS_ERROR]: 'Ошибка',
};

export function getOrderRefundStatusText(
    status: EOrderPaymentRefundState,
    isTechTexts: boolean,
): string {
    return !isTechTexts && ORDER_REFUND_STATUS_DICT[status]
        ? ORDER_REFUND_STATUS_DICT[status]
        : status;
}
