import {EOrderPaymentResizeState} from 'redux/reducers/types';

export const ORDER_RESIZE_STATUS_DICT = {
    [EOrderPaymentResizeState.RSS_SUCCESS]: 'Деньги возвращены',
    [EOrderPaymentResizeState.RSS_UNKNOWN]: 'Неизвестный статус',
};

export function getOrderResizeStatusText(
    status: EOrderPaymentResizeState,
    isTechTexts: boolean,
): string {
    return !isTechTexts && ORDER_RESIZE_STATUS_DICT[status]
        ? ORDER_RESIZE_STATUS_DICT[status]
        : status;
}
