import {PaymentScheduleType} from 'redux/reducers/types';

export const PAYMENT_SCHEDULE_TYPE_DICT = {
    [PaymentScheduleType.PST_UNKNOWN]: 'Не важно',
    [PaymentScheduleType.PST_DEFERRED]: 'В рассрочку',
    [PaymentScheduleType.PST_FULL]: 'Полная оплата',
};

export function getPaymentScheduleTypeText(
    type: PaymentScheduleType,
    isTechTexts: boolean,
): string {
    return !isTechTexts && PAYMENT_SCHEDULE_TYPE_DICT[type]
        ? PAYMENT_SCHEDULE_TYPE_DICT[type]
        : type;
}
