// imported from https://github.com/skbkontur/retail-ui/blob/9f0fcbfc49cc996e14453df1ba92c6e33410ce57/packages/retail-ui/lib/dom/getScrollWidth.tsx
// MIT License
// Copyright (c) 2017 SKB Kontur

let scrollbarWidth: number | null = null;

export default function getScrollWidth() {
    const {body} = document;

    if (!body) {
        throw Error('There is no "body" element in "document"');
    }

    if (scrollbarWidth !== null) {
        return scrollbarWidth;
    }

    const div = document.createElement('div');

    div.innerHTML = 'a'; // In IE clientWidth is 0 if this div is empty.
    div.style.overflowY = 'scroll';
    body.appendChild(div);
    // At least in jest it's NaN.
    scrollbarWidth = div.offsetWidth - div.clientWidth || 0;
    body.removeChild(div);

    return scrollbarWidth;
}
