import {IHotelOrderGuest} from 'redux/reducers/types/hotel';

export default function checkUpdates(
    originGuests: IHotelOrderGuest[],
    updatedGuests: IHotelOrderGuest[],
) {
    if (originGuests.length !== updatedGuests.length) {
        return true;
    }

    return originGuests.some((originGuest, index) => {
        const updatedGuest = updatedGuests[index];

        const childIsUpdated =
            originGuest.child === undefined
                ? updatedGuest.child
                : originGuest.child !== updatedGuest.child;

        return (
            originGuest.first_name !== updatedGuest.first_name ||
            originGuest.last_name !== updatedGuest.last_name ||
            originGuest.age !== updatedGuest.age ||
            childIsUpdated
        );
    });
}
