import {IHotelOrderGuest} from 'redux/reducers/types/hotel';

export default function validateGuests(guests: IHotelOrderGuest[]) {
    return guests.every(guest => {
        const isValidAge =
            !guest.child ||
            (Boolean(guest.age) &&
                !Number.isNaN(Number(guest.age)) &&
                Number(guest.age) >= 0);

        return (
            Boolean(guest.first_name) && Boolean(guest.last_name) && isValidAge
        );
    });
}
