import {parse, stringify, ParsedQuery} from 'query-string';

export function getParsedQueryFromUrl(url: string): ParsedQuery {
    const {1: search} = url.split('?');

    return parseSearch(`?${search}`);
}

export function parseSearch(search: string): ParsedQuery {
    return search ? parse(search.substr(1)) : {};
}

export function extendSearch<T extends ObjectWithStrings<T>>(
    search: string,
    props: T,
): string {
    return `?${stringify({
        ...parseSearch(search),
        ...props,
    })}`;
}

export function extendUrl<T extends ObjectWithStrings<T>>(
    location: {pathname: string; search: string},
    props: T,
): string {
    return `${location.pathname}${extendSearch(location.search, props)}`;
}
