import {createAction, createAsyncAction} from 'typesafe-actions';
import {AddToast} from 'react-toast-notifications';

import {
    ICalculatedHotelMoneyOnlyRefund,
    ICalculatedHotelOrderRefund,
    IFetchError,
    IOrderInfo,
    IOrderLog,
    IOrderPayloadInfo,
    IOrderStartrekTicket,
    OrderLogLevel,
    OrderNotificationTransport,
    OrderNotificationType,
} from 'redux/reducers/types';
import {IHotelOrderGuest} from 'redux/reducers/types/hotel';

import {OrderRefundType} from 'components/Order/OrderRefund/OrderRefund';

const {
    request: orderRequest,
    success: orderRequestSuccess,
    failure: orderRequestFailure,
} = createAsyncAction(
    'ORDER.FETCH_ORDER',
    'ORDER.SET_ORDER_FETCH_SUCCESS',
    'ORDER.SET_ORDER_FETCH_FAILURE',
)<
    {orderId: string; needToFetchPersonalData: boolean},
    IOrderInfo,
    IFetchError
>();

export const resetOrder = createAction('ORDER.RESET')();

export interface IOrderLogsRequestParams {
    orderId: string;
    page?: number;
    count?: number;
    level?: OrderLogLevel;
    logger?: string;
    message?: string;
}

const {
    request: orderLogsRequest,
    success: orderLogsRequestSuccess,
    failure: orderLogsRequestFailure,
} = createAsyncAction(
    'ORDER.FETCH_LOGS',
    'ORDER.SET_LOGS_FETCH_SUCCESS',
    'ORDER.SET_LOGS_FETCH_FAILURE',
)<
    IOrderLogsRequestParams,
    {
        records: IOrderLog[];
        count: number;
    },
    IFetchError
>();

export const resetOrderLogs = createAction('ORDER.RESET_LOGS')();

export interface IOrderWorkflowRequestParams {
    workflowId: string;
}

const {
    request: orderWorkflowRequest,
    success: orderWorkflowRequestSuccess,
    failure: orderWorkflowRequestFailure,
} = createAsyncAction(
    'ORDER.FETCH_WORKFLOW',
    'ORDER.SET_WORKFLOW_FETCH_SUCCESS',
    'ORDER.SET_WORKFLOW_FETCH_FAILURE',
)<IOrderWorkflowRequestParams, any, IFetchError>();

export const resetOrderWorkflow = createAction('ORDER.RESET_WORKFLOW')();

export interface IOrderPayloadsRequestParams {
    orderId: string;
}

const {
    request: orderPayloadsRequest,
    success: orderPayloadsRequestSuccess,
    failure: orderPayloadsRequestFailure,
} = createAsyncAction(
    'ORDER.FETCH_PAYLOADS',
    'ORDER.SET_PAYLOADS_FETCH_SUCCESS',
    'ORDER.SET_PAYLOADS_FETCH_FAILURE',
)<IOrderPayloadsRequestParams, IOrderPayloadInfo[], IFetchError>();

export const resetOrderPayloads = createAction('ORDER.RESET_PAYLOADS')();

export interface IOrderEditPayloadRequestParams {
    order_id: string;
    order_item_id: string;
    payload: object;
    addToast: AddToast;
}

const {
    request: orderEditPayloadRequest,
    success: orderEditPayloadRequestSuccess,
    failure: orderEditPayloadRequestFailure,
} = createAsyncAction(
    'ORDER.FETCH_EDIT_PAYLOAD',
    'ORDER.SET_EDIT_PAYLOAD_FETCH_SUCCESS',
    'ORDER.SET_EDIT_PAYLOAD_FETCH_FAILURE',
)<IOrderEditPayloadRequestParams, undefined, IFetchError>();

export const resetOrderEditPayload = createAction('ORDER.RESET_EDIT_PAYLOAD')();

export interface IOrderEditEmailRequestParams {
    orderId: string;
    newEmail: string;
    addToast: AddToast;
}

const {
    request: orderEditEmailRequest,
    success: orderEditEmailRequestSuccess,
    failure: orderEditEmailRequestFailure,
} = createAsyncAction(
    'ORDER.FETCH_EDIT_EMAIL',
    'ORDER.SET_EDIT_EMAIL_FETCH_SUCCESS',
    'ORDER.SET_EDIT_EMAIL_FETCH_FAILURE',
)<IOrderEditEmailRequestParams, undefined, IFetchError>();

export const resetOrderEditEmail = createAction('ORDER.RESET_EDIT_EMAIL')();

export interface IOrderEditPhoneRequestParams {
    orderId: string;
    newPhone: string;
    addToast: AddToast;
}

const {
    request: orderEditPhoneRequest,
    success: orderEditPhoneRequestSuccess,
    failure: orderEditPhoneRequestFailure,
} = createAsyncAction(
    'ORDER.FETCH_EDIT_PHONE',
    'ORDER.SET_EDIT_PHONE_FETCH_SUCCESS',
    'ORDER.SET_EDIT_PHONE_FETCH_FAILURE',
)<IOrderEditPhoneRequestParams, undefined, IFetchError>();

export const resetOrderEditPhone = createAction('ORDER.RESET_EDIT_PHONE')();

export interface IOrderSendNotificationRequestParams {
    orderId: string;
    type: OrderNotificationType;
    transport: OrderNotificationTransport;
    orderRefundId?: string;
    addToast: AddToast;
}

const {
    request: orderSendNotificationRequest,
    success: orderSendNotificationRequestSuccess,
    failure: orderSendNotificationRequestFailure,
} = createAsyncAction(
    'ORDER.FETCH_SEND_NOTIFICATION',
    'ORDER.SET_SEND_NOTIFICATION_FETCH_SUCCESS',
    'ORDER.SET_EDIT_SEND_NOTIFICATION_FETCH_FAILURE',
)<IOrderSendNotificationRequestParams, undefined, IFetchError>();

export const resetOrderSendNotification = createAction(
    'ORDER.RESET_SEND_NOTIFICATION',
)();

export interface IOrderRetryMoneyRefundRequestParams {
    orderId: string;
    adminActionToken: string;
    orderRefundId?: string;
    addToast: AddToast;
}

const {
    request: orderRetryMoneyRefundRequest,
    success: orderRetryMoneyRefundRequestSuccess,
    failure: orderRetryMoneyRefundRequestFailure,
} = createAsyncAction(
    'ORDER.FETCH_RETRY_MONEY_REFUND',
    'ORDER.SET_RETRY_MONEY_REFUND_FETCH_SUCCESS',
    'ORDER.SET_RETRY_MONEY_REFUND_FETCH_FAILURE',
)<IOrderRetryMoneyRefundRequestParams, undefined, IFetchError>();

export const resetOrderRetryMoneyRefund = createAction(
    'ORDER.RESET_RETRY_MONEY_REFUND',
)();

export interface IOrderUpdateTrainTicketsRequestParams {
    orderId: string;
    addToast: AddToast;
}

const {
    request: orderUpdateTrainTicketsRequest,
    success: orderUpdateTrainTicketsRequestSuccess,
    failure: orderUpdateTrainTicketsRequestFailure,
} = createAsyncAction(
    'ORDER.FETCH_UPDATE_TRAIN_TICKETS',
    'ORDER.UPDATE_TRAIN_TICKETS_FETCH_SUCCESS',
    'ORDER.UPDATE_TRAIN_TICKETS_FETCH_FAILURE',
)<IOrderUpdateTrainTicketsRequestParams, undefined, IFetchError>();

export const orderUpdateTrainTicketsRequestTimeout = createAction(
    'ORDER.UPDATE_TRAIN_TICKETS_FETCH_TIMEOUT',
)();

export const resetOrderUpdateTrainTickets = createAction(
    'ORDER.RESET_UPDATE_TRAIN_TICKETS',
)();

export interface IOrderRefundRequestParamsPartly {
    orderId: string;
    adminActionToken: string;
    reason: string;
    refundType: OrderRefundType.PARTLY;
    addToast: AddToast;
    refundsByFiscalItem: Record<number, {value: number; currency: string}>;
}
export interface IOrderRefundRequestParams {
    orderId: string;
    adminActionToken: string;
    reason: string;
    refundType: OrderRefundType;
    addToast: AddToast;
    refundsByFiscalItem: null;
}

export type OrderRefundRequestParams =
    | IOrderRefundRequestParamsPartly
    | IOrderRefundRequestParams;

const {
    request: orderRefundRequest,
    success: orderRefundRequestSuccess,
    failure: orderRefundRequestFailure,
} = createAsyncAction(
    'ORDER.FETCH_REFUND',
    'ORDER.REFUND_FETCH_SUCCESS',
    'ORDER.REFUND_FETCH_FAILURE',
)<OrderRefundRequestParams, undefined, IFetchError>();

export const orderRefundRequestTimeout = createAction(
    'ORDER.REFUND_FETCH_TIMEOUT',
)();

export const resetOrderRefund = createAction('ORDER.RESET_REFUND')();

export interface IOrderStartrekTicketsRequestParams {
    ticketsIds: string[];
}

const {
    request: orderStartrekTicketsRequest,
    success: orderStartrekTicketsRequestSuccess,
    failure: orderStartrekTicketsRequestFailure,
} = createAsyncAction(
    'ORDER.FETCH_STARTREK_TICKETS',
    'ORDER.STARTREK_TICKETS_FETCH_SUCCESS',
    'ORDER.STARTREK_TICKETS_FETCH_FAILURE',
)<IOrderStartrekTicketsRequestParams, IOrderStartrekTicket[], unknown>();

export const resetOrderStartrekTickets = createAction(
    'ORDER.RESET_STARTREK_TICKETS',
)();

export interface IOrderRestoreDolphinOrderRequestParams {
    orderId: string;
    cancel: boolean;
    addToast: AddToast;
}

const {
    request: restoreDolphinOrderRequest,
    success: restoreDolphinOrderRequestSuccess,
    failure: restoreDolphinOrderRequestFailure,
} = createAsyncAction(
    'ORDER.FETCH_RESTORE_DOLPHIN_ORDER',
    'ORDER.RESTORE_DOLPHIN_ORDER_FETCH_SUCCESS',
    'ORDER.RESTORE_DOLPHIN_ORDER_FETCH_FAILURE',
)<IOrderRestoreDolphinOrderRequestParams, undefined, IFetchError>();

export interface IOrderRegenerateVouchersRequestParams {
    orderId: string;
    addToast: AddToast;
}

const {
    request: regenerateVouchersRequest,
    success: regenerateVouchersRequestSuccess,
    failure: regenerateVouchersRequestFailure,
} = createAsyncAction(
    'ORDER.FETCH_REGENERATE_VOUCHERS',
    'ORDER.REGENERATE_VOUCHERS_FETCH_SUCCESS',
    'ORDER.REGENERATE_VOUCHERS_FETCH_FAILURE',
)<IOrderRegenerateVouchersRequestParams, undefined, IFetchError>();

export interface IRefundHotelOrderRequestParams {
    orderId: string;
    addToast: AddToast;
    adminActionToken: string;
    generateFinEvents: boolean;
    refundAmount: {value: number; currency: string};
    reason: string;
}

const {
    request: refundHotelOrderRequest,
    success: refundHotelOrderRequestSuccess,
    failure: refundHotelOrderRequestFailure,
} = createAsyncAction(
    'ORDER.FETCH_REFUND_HOTEL_ORDER',
    'ORDER.REFUND_HOTEL_ORDER_FETCH_SUCCESS',
    'ORDER.REFUND_HOTEL_ORDER_FETCH_FAILURE',
)<IRefundHotelOrderRequestParams, undefined, IFetchError>();

export interface ICalculateHotelOrderRefundRequestParams {
    orderId: string;
    addToast: AddToast;
}

const {
    request: calculateHotelOrderRefundRequest,
    success: calculateHotelOrderRefundRequestSuccess,
    failure: calculateHotelOrderRefundRequestFailure,
} = createAsyncAction(
    'ORDER.FETCH_CALCULATE_HOTEL_ORDER_REFUND',
    'ORDER.CALCULATE_HOTEL_ORDER_REFUND_FETCH_SUCCESS',
    'ORDER.CALCULATE_HOTEL_ORDER_REFUND_FETCH_FAILURE',
)<
    ICalculateHotelOrderRefundRequestParams,
    ICalculatedHotelOrderRefund,
    IFetchError
>();

export interface ICalculateHotelMoneyOnlyRefundRequestParams {
    orderId: string;
    addToast: AddToast;
}

const {
    request: calculateHotelMoneyOnlyRefundRequest,
    success: calculateHotelMoneyOnlyRefundRequestSuccess,
    failure: calculateHotelMoneyOnlyRefundRequestFailure,
} = createAsyncAction(
    'ORDER.FETCH_CALCULATE_HOTEL_MONEY_ONLY_REFUND',
    'ORDER.CALCULATE_HOTEL_MONEY_ONLY_REFUND_FETCH_SUCCESS',
    'ORDER.CALCULATE_HOTEL_MONEY_ONLY_REFUND_FETCH_FAILURE',
)<
    ICalculateHotelMoneyOnlyRefundRequestParams,
    ICalculatedHotelMoneyOnlyRefund,
    IFetchError
>();

export interface IRefundHotelMoneyOnlyRequestParams {
    orderId: string;
    addToast: AddToast;
    adminActionToken: string;
    refundUserMoney: boolean;
    generateFinEvents: boolean;
    refundAmount: {value: number; currency: string};
    newInvoiceAmount: {value: number; currency: string};
    reason: string;
}

const {
    request: refundHotelMoneyOnlyRequest,
    success: refundHotelMoneyOnlyRequestSuccess,
    failure: refundHotelMoneyOnlyRequestFailure,
} = createAsyncAction(
    'ORDER.FETCH_REFUND_HOTEL_MONEY_ONLY',
    'ORDER.REFUND_HOTEL_MONEY_ONLY_FETCH_SUCCESS',
    'ORDER.REFUND_HOTEL_MONEY_ONLY_FETCH_FAILURE',
)<IRefundHotelMoneyOnlyRequestParams, undefined, IFetchError>();

export interface IModifyDates {
    checkin_date: string;
    checkout_date: string;
}

export interface IModifyHotelOrderDetailsRequestParams {
    orderId: string;
    addToast: AddToast;
    adminActionToken: string;
    dates?: IModifyDates;
    guests?: {
        guests: IHotelOrderGuest[];
    };
    reason: string;
}

const {
    request: modifyHotelOrderDetailsRequest,
    success: modifyHotelOrderDetailsRequestSuccess,
    failure: modifyHotelOrderDetailsRequestFailure,
} = createAsyncAction(
    'ORDER.FETCH_MODIFY_HOTEL_ORDER_DETAILS',
    'ORDER.MODIFY_HOTEL_ORDER_DETAILS_SUCCESS',
    'ORDER.MODIFY_HOTEL_ORDER_DETAILS_FAILURE',
)<IModifyHotelOrderDetailsRequestParams, undefined, IFetchError>();

export {
    orderRequest,
    orderRequestSuccess,
    orderRequestFailure,
    orderLogsRequest,
    orderLogsRequestSuccess,
    orderLogsRequestFailure,
    orderWorkflowRequest,
    orderWorkflowRequestSuccess,
    orderWorkflowRequestFailure,
    orderPayloadsRequest,
    orderPayloadsRequestSuccess,
    orderPayloadsRequestFailure,
    orderEditPayloadRequest,
    orderEditPayloadRequestSuccess,
    orderEditPayloadRequestFailure,
    orderEditEmailRequest,
    orderEditEmailRequestSuccess,
    orderEditEmailRequestFailure,
    orderEditPhoneRequest,
    orderEditPhoneRequestSuccess,
    orderEditPhoneRequestFailure,
    orderSendNotificationRequest,
    orderSendNotificationRequestSuccess,
    orderSendNotificationRequestFailure,
    orderRetryMoneyRefundRequest,
    orderRetryMoneyRefundRequestSuccess,
    orderRetryMoneyRefundRequestFailure,
    orderUpdateTrainTicketsRequest,
    orderUpdateTrainTicketsRequestSuccess,
    orderUpdateTrainTicketsRequestFailure,
    orderRefundRequest,
    orderRefundRequestSuccess,
    orderRefundRequestFailure,
    orderStartrekTicketsRequest,
    orderStartrekTicketsRequestSuccess,
    orderStartrekTicketsRequestFailure,
    restoreDolphinOrderRequest,
    restoreDolphinOrderRequestSuccess,
    restoreDolphinOrderRequestFailure,
    regenerateVouchersRequest,
    regenerateVouchersRequestSuccess,
    regenerateVouchersRequestFailure,
    refundHotelOrderRequest,
    refundHotelOrderRequestSuccess,
    refundHotelOrderRequestFailure,
    calculateHotelOrderRefundRequest,
    calculateHotelOrderRefundRequestSuccess,
    calculateHotelOrderRefundRequestFailure,
    calculateHotelMoneyOnlyRefundRequest,
    calculateHotelMoneyOnlyRefundRequestSuccess,
    calculateHotelMoneyOnlyRefundRequestFailure,
    refundHotelMoneyOnlyRequest,
    refundHotelMoneyOnlyRequestSuccess,
    refundHotelMoneyOnlyRequestFailure,
    modifyHotelOrderDetailsRequest,
    modifyHotelOrderDetailsRequestSuccess,
    modifyHotelOrderDetailsRequestFailure,
};
